<div class="wrap">
<?php
/*
	WPsyslog -- Global logging facility for WordPress
	Copyright (C) 2007 Alex Guensche <http://www.zirona.com>

	This program is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation in the Version 2.
	
	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.
*/

if ( !current_user_can('level_10') && !current_user_can('read_wpsyslog') )
	echo '<p>'.__('Sorry, this is not for you.', 'wpsyslog').'</p>';
else {

function wpsyslogAssembleRequestData() {

	$search = $_POST['wpsyslog_filter_search'];
	$andor1 = $_POST['wpsyslog_filter_andor1'];
	$modules = $_POST['wpsyslog_filter_modules'];
	$andor2 = $_POST['wpsyslog_filter_andor2'];
	$severityLevels = $_POST['wpsyslog_filter_levels'];
	$andor3 = $_POST['wpsyslog_filter_andor3'];
	$users = $_POST['wpsyslog_filter_users'];
	$andor4 = $_POST['wpsyslog_filter_andor4'];
	$timeStart = $_POST['wpsyslog_filter_timestart'];
	$timeEnd = $_POST['wpsyslog_filter_timeend'];
	$orderby = $_POST['wpsyslog_filter_orderby'];
	$order = $_POST['wpsyslog_filter_order'];
	$limit = $_POST['wpsyslog_filter_limit'];

	global $wpdb;

	$andor1 = ('OR' == $andor1) ? 'OR' : 'AND';
	$andor2 = ('OR' == $andor2) ? 'OR' : 'AND';
	$andor3 = ('OR' == $andor3) ? 'OR' : 'AND';
	$andor4 = ('OR' == $andor4) ? 'OR' : 'AND';

	$search = strip_tags($search);
	$search = $wpdb->escape($search);

	// What modules shall be displayed?
	if ( is_array($modules) )
		foreach ($modules as $k=>$v)
			$modules[$k] = preg_replace('|[^a-z0-9_]|', '', $v);
	else
		$modules = 'all';

	// What severity levels shall be displayed?
	if ( is_array($severityLevels) ) {
		foreach ($severityLevels as $k=>$v)
			if ( !is_numeric($v) || 0 > $v || 5 < $v )
				$severityLevels[$k] = '10';
	} else
		$severityLevels = 'all';

	// Which users shall be displayed?
	if ( is_array($users) ) {
		foreach ($users as $k=>$v)
			if ( !is_numeric($v) || 1 > $v )
				$users[$k] = '0';
	} else
		$users = 'all';

	// Where should the timeframe start?
	$timeStart = preg_replace('|[^0-9:-\s]|', '', $timeStart);
	$timeStart = strtotime($timeStart);
	if (1181677869 > $timeStart || 2147483647 < $timeStart)
		$timeStart = 1181677869;

	// Where should the timeframe end?
	$timeEnd = preg_replace('|[^0-9:-\s]|', '', $timeEnd);
	$timeEnd = strtotime($timeEnd);
	if (1181677869 > $timeEnd || 2147483647 < $timeEnd)
		$timeEnd = 2147483647;

	$orderby = ('time' == $orderby || 'module' == $orderby || 'severity' == $orderby || 'user' == $orderby)
		? $orderby
		: 'id';

	$order = ('ASC' == $order) ? 'ASC' : 'DESC';

	// How many entries shall be displayed at most?
	$limit = (int)$limit;
	$limit = (1 > $limit || 5000 < $limit)
		? 100
		: $limit;

	$wpsyslogRequestParsed = true;

	return compact(
		'search',
		'andor1',
		'modules',
		'andor2',
		'severityLevels',
		'andor3',
		'users',
		'andor4',
		'timeStart',
		'timeEnd',
		'orderby',
		'order',
		'limit'
	);
}

function wpsyslogFetchLogData($args) {
	global $wpdb;

	extract($args);

	$search = ( !empty($search) )
		? "`message` LIKE '%$search%'"
		: '';

	// What modules shall be displayed?
	if ( is_array($modules) ) {
		foreach ($modules as $k=>$v)
			$modules[$k] = "'$v'";
		$modules = implode(', ', $modules);
		$modules = "`module` IN ($modules)";
	}
	else
		$modules = '';

	// What severity levels shall be displayed?
	if ( is_array($severityLevels) ) {
		foreach ($severityLevels as $k=>$v)
			$severityLevels[$k] = "'$v'";
		$severityLevels = implode(', ', $severityLevels);
		$severityLevels = "`severity` IN ($severityLevels)";
	} else
		$severityLevels = '';

	// Which users shall be displayed?
	if ( is_array($users) ) {
		foreach ($users as $k=>$v)
			$users[$k] = "'$v'";
		$users = implode(', ', $users);
		$users = "`user` IN ($users)";
	} else
		$users = '';

	$timeStart = date('Y-m-d H:i:s', (int)$timeStart);
	$timeStart = "`time` > '$timeStart'";

	$timeEnd = date('Y-m-d H:i:s', (int)$timeEnd);
	$timeEnd = "`time` < '$timeEnd'";

	$orderby = "ORDER BY `$orderby`";
	$limit = "LIMIT $limit";

	$andor1 = ( !empty($search) ) ? $andor1 : '';
	$andor2 = ( !empty($modules) ) ? $andor2 : '';
	$andor3 = ( !empty($severityLevels) ) ? $andor3 : '';
	$andor4 = ( !empty($users) ) ? $andor4 : '';

	$query =
		"SELECT * FROM {$wpdb->prefix}wpsyslog ".
		"WHERE $search $andor1 ($modules $andor2 ($severityLevels $andor3 ($users $andor4 ($timeStart AND $timeEnd)))) ".
		"$orderby $order $limit";

	if ('on' == $_POST['wpsyslog_show_query'])
		$_POST['wpsyslog_show_query'] = '<p id="wpsyslog_query">'.$query.'</p>';
	else
		$_POST['wpsyslog_show_query'] = '';

	$result = $wpdb->get_results($query);
	return $result;
}

global $wpdb;
$wpsyslogRequest = wpsyslogAssembleRequestData();
$wpsyslogData = wpsyslogFetchLogData($wpsyslogRequest);
$wpsyslogLoggedModules = $wpdb->get_col("SELECT DISTINCT `module` FROM `{$wpdb->prefix}wpsyslog`");
$wpsyslogSystemUsers = $wpdb->get_results("SELECT `id`, `user_login` FROM `{$wpdb->users}`");
?>

<script type="text/javascript">
//<![CDATA[
	function toggleFilterSection() {
		if (document.getElementById('wpsyslog_filter').style.display == 'none') {
			document.getElementById('wpsyslog_filter').style.display='block';
			document.getElementById('filter_toggle').firstChild.data='<?php echo __('Hide filter options', 'wpsyslog') ?>';
			document.cookie='wpsyslog_show_filters=true;path=/';
		} else {
			document.getElementById('wpsyslog_filter').style.display='none';
			document.getElementById('filter_toggle').firstChild.data='<?php echo __('Show filter options', 'wpsyslog') ?>';
			document.cookie='wpsyslog_show_filters=false;path=/';
		}
	}
//]]>
</script>

<strong onclick="toggleFilterSection()" id="filter_toggle"><?php echo ('true' != $_COOKIE['wpsyslog_show_filters'] ? __('Show filter options', 'wpsyslog') : __('Hide filter options', 'wpsyslog')); ?></strong>

<form action="<?php echo $_SERVER['REQUEST_URI'] ?>" method="post" id="wpsyslog_filter"<?php echo ('true' != $_COOKIE['wpsyslog_show_filters'] ? ' style="display: none;"' : ''); ?>>
	<p><?php echo __('The <a href="http://en.wikipedia.org/wiki/Boolean_logic#Use_of_parentheses">Boolean logic</a> is <code><strong>searchterm and/or (modules and/or (levels and/or (users and/or (start and end))))</strong></code>.', 'wpsyslog') ?><br /><?php echo __('If a field is left empty, it will be ignored (i.e. not be used to narrow down the result). In the select fields, you can select multiple values (Ctrl+click).', 'wpsyslog') ?></p>
	<div class="inputsection">
		<p>
			<label for="wpsyslog_filter_search"><strong><?php echo __('Search string:', 'wpsyslog') ?></strong></label><br />
			<input type="text" name="wpsyslog_filter_search" id="wpsyslog_filter_search" size="10" value="<?php echo $wpsyslogRequest['search'] ?>" />
		</p>
	</div>

	<div class="inputsection">
		<p>
			<input type="radio" name="wpsyslog_filter_andor1" value="AND" id="wpsyslog_filter_andor1_and"<?php echo ($wpsyslogRequest['andor1'] == 'AND' ? ' checked="checked"' : '') ?> />&nbsp;<label for="wpsyslog_filter_andor1_and"><?php echo __('and', 'wpsyslog') ?></label><br />
			<input type="radio" name="wpsyslog_filter_andor1" value="OR" id="wpsyslog_filter_andor1_or"<?php echo ($wpsyslogRequest['andor1'] == 'OR' ? ' checked="checked"' : '') ?> />&nbsp;<label for="wpsyslog_filter_andor1_or"><?php echo __('or', 'wpsyslog') ?></label>
		</p>
	</div>

	<div class="inputsection">
		<p>
			<label for="wpsyslog_filter_modules"><strong><?php echo __('Modules:', 'wpsyslog') ?></strong></label><br />
			<select size="6" name="wpsyslog_filter_modules[]" id="wpsyslog_filter_modules" multiple="multiple">
			<?php
				foreach ($wpsyslogLoggedModules as $loggedModule) : if ( !empty($loggedModule) ) :
					$selected = ( is_array($wpsyslogRequest['modules']) && in_array($loggedModule, $wpsyslogRequest['modules']) ? ' selected="selected"' : '' );
					echo '<option value="'.$loggedModule.'" '.$selected.'>'.$loggedModule.'</option>';
				endif; endforeach;
			?>
			</select>
		</p>
	</div>

	<div class="inputsection">
		<p>
			<input type="radio" name="wpsyslog_filter_andor2" value="AND" id="wpsyslog_filter_andor2_and"<?php echo ($wpsyslogRequest['andor2'] == 'AND' ? ' checked="checked"' : '') ?> />&nbsp;<label for="wpsyslog_filter_andor2_and"><?php echo __('and', 'wpsyslog') ?></label><br />
			<input type="radio" name="wpsyslog_filter_andor2" value="OR" id="wpsyslog_filter_andor2_or"<?php echo ($wpsyslogRequest['andor2'] == 'OR' ? ' checked="checked"' : '') ?> />&nbsp;<label for="wpsyslog_filter_andor2_or"><?php echo __('or', 'wpsyslog') ?></label>
		</p>
	</div>

	<div class="inputsection">
		<p>
			<label for="wpsyslog_filter_levels"><strong><?php echo __('Severity levels:', 'wpsyslog') ?></strong></label><br />
			<select size="6" name="wpsyslog_filter_levels[]" id="wpsyslog_filter_levels" multiple="multiple">
				<option value="0"<?php echo (is_array($wpsyslogRequest['severityLevels']) && in_array('0', $wpsyslogRequest['severityLevels']) ? ' selected="selected"' : ''); ?>><?php echo __('Debug', 'wpsyslog') ?></option>
				<option value="1"<?php echo (is_array($wpsyslogRequest['severityLevels']) && in_array('1', $wpsyslogRequest['severityLevels']) ? ' selected="selected"' : ''); ?>><?php echo __('Notice', 'wpsyslog') ?></option>
				<option value="2"<?php echo (is_array($wpsyslogRequest['severityLevels']) && in_array('2', $wpsyslogRequest['severityLevels']) ? ' selected="selected"' : ''); ?>><?php echo __('Important', 'wpsyslog') ?></option>
				<option value="3"<?php echo (is_array($wpsyslogRequest['severityLevels']) && in_array('3', $wpsyslogRequest['severityLevels']) ? ' selected="selected"' : ''); ?>><?php echo __('Warning', 'wpsyslog') ?></option>
				<option value="4"<?php echo (is_array($wpsyslogRequest['severityLevels']) && in_array('4', $wpsyslogRequest['severityLevels']) ? ' selected="selected"' : ''); ?>><?php echo __('Error', 'wpsyslog') ?></option>
				<option value="5"<?php echo (is_array($wpsyslogRequest['severityLevels']) && in_array('5', $wpsyslogRequest['severityLevels']) ? ' selected="selected"' : ''); ?>><?php echo __('Panic', 'wpsyslog') ?></option>
			</select>
		</p>
	</div>

	<div class="inputsection">
		<p>
			<input type="radio" name="wpsyslog_filter_andor3" value="AND" id="wpsyslog_filter_andor3_and"<?php echo ($wpsyslogRequest['andor3'] == 'AND' ? ' checked="checked"' : '') ?> />&nbsp;<label for="wpsyslog_filter_andor3_and"><?php echo __('and', 'wpsyslog') ?></label><br />
			<input type="radio" name="wpsyslog_filter_andor3" value="OR" id="wpsyslog_filter_andor3_or"<?php echo ($wpsyslogRequest['andor3'] == 'OR' ? ' checked="checked"' : '') ?> />&nbsp;<label for="wpsyslog_filter_andor3_or"><?php echo __('or', 'wpsyslog') ?></label>
		</p>
	</div>

	<div class="inputsection">
		<p>
			<label for="wpsyslog_filter_users"><strong><?php echo __('Users:', 'wpsyslog') ?></strong></label><br />
			<select size="6" name="wpsyslog_filter_users[]" id="wpsyslog_filter_users" multiple="multiple">
			<?php
				foreach ($wpsyslogSystemUsers as $systemUser) :
					$selected = (is_array($wpsyslogRequest['users']) && in_array($systemUser->id, $wpsyslogRequest['users']) ? ' selected="selected"' : '');
					echo '<option value="'.$systemUser->id.'" '.$selected.'>'.$systemUser->user_login.'</option>';
				endforeach;
			?>
			</select>
		</p>
	</div>

	<div class="inputsection">
		<p>
			<input type="radio" name="wpsyslog_filter_andor4" value="AND" id="wpsyslog_filter_andor4_and"<?php echo ($wpsyslogRequest['andor4'] == 'AND' ? ' checked="checked"' : '') ?> />&nbsp;<label for="wpsyslog_filter_andor4_and"><?php echo __('and', 'wpsyslog') ?></label><br />
			<input type="radio" name="wpsyslog_filter_andor4" value="OR" id="wpsyslog_filter_andor4_or"<?php echo ($wpsyslogRequest['andor4'] == 'OR' ? ' checked="checked"' : '') ?> />&nbsp;<label for="wpsyslog_filter_andor4_or"><?php echo __('or', 'wpsyslog') ?></label>
		</p>
	</div>

	<div class="inputsection">
		<p>
			<label for="wpsyslog_filter_timestart"><strong><?php echo __('Start Time:', 'wpsyslog') ?></strong></label><br />
			<input type="text" name="wpsyslog_filter_timestart" id="wpsyslog_filter_timestart" size="11" value="<?php echo (1181677869 != $wpsyslogRequest['timeStart']) ? date('Y-m-d H:i:s', $wpsyslogRequest['timeStart']) : '' ?>" />
		</p>
		<p>
			<label for="wpsyslog_filter_timeend"><strong><?php echo __('End Time:', 'wpsyslog') ?></strong></label><br />
			<input type="text" name="wpsyslog_filter_timeend" id="wpsyslog_filter_timeend" size="11" value="<?php echo (2147483647 != $wpsyslogRequest['timeEnd']) ? date('Y-m-d H:i:s', $wpsyslogRequest['timeEnd']) : '' ?>" />
		</p>
		<p><?php echo __('(Format:<br /><code><a href="http://php.net/date">Y-m-d H:i:s</a></code>)', 'wpsyslog') ?></p>
	</div>

	<div class="inputsection">
		<p>
			<strong><?php echo __('Sort by:', 'wpsyslog') ?></strong><br />
			<input type="radio" name="wpsyslog_filter_orderby" value="id" id="wpsyslog_filter_orderby_id"<?php echo ($wpsyslogRequest['orderby'] == 'id' ? ' checked="checked"' : '') ?> />&nbsp;<label for="wpsyslog_filter_orderby_id"><?php echo __('event ID', 'wpsyslog') ?></label><br />
			<input type="radio" name="wpsyslog_filter_orderby" value="time" id="wpsyslog_filter_orderby_time"<?php echo ($wpsyslogRequest['time'] == 'time' ? ' checked="checked"' : '') ?> />&nbsp;<label for="wpsyslog_filter_orderby_time"><?php echo __('time', 'wpsyslog') ?></label><br />
			<input type="radio" name="wpsyslog_filter_orderby" value="module" id="wpsyslog_filter_orderby_module"<?php echo ($wpsyslogRequest['module'] == 'id' ? ' checked="checked"' : '') ?> />&nbsp;<label for="wpsyslog_filter_orderby_module"><?php echo __('module', 'wpsyslog') ?></label><br />
			<input type="radio" name="wpsyslog_filter_orderby" value="severity" id="wpsyslog_filter_orderby_severity"<?php echo ($wpsyslogRequest['severity'] == 'id' ? ' checked="checked"' : '') ?> />&nbsp;<label for="wpsyslog_filter_orderby_severity"><?php echo __('severity', 'wpsyslog') ?></label><br />
			<input type="radio" name="wpsyslog_filter_orderby" value="user" id="wpsyslog_filter_orderby_user"<?php echo ($wpsyslogRequest['user'] == 'id' ? ' checked="checked"' : '') ?> />&nbsp;<label for="wpsyslog_filter_orderby_user"><?php echo __('user', 'wpsyslog') ?></label>
		</p>
		<p>
			<strong><?php echo __('Order:', 'wpsyslog') ?></strong><br />
			<input type="radio" name="wpsyslog_filter_order" value="DESC" id="wpsyslog_filter_order_desc"<?php echo ($wpsyslogRequest['order'] == 'DESC' ? ' checked="checked"' : '') ?> />&nbsp;<label for="wpsyslog_filter_order_desc"><?php echo __('desecending', 'wpsyslog') ?></label><br />
			<input type="radio" name="wpsyslog_filter_order" value="ASC" id="wpsyslog_filter_order_asc"<?php echo ($wpsyslogRequest['order'] == 'ASC' ? ' checked="checked"' : '') ?> />&nbsp;<label for="wpsyslog_filter_order_asc"><?php echo __('ascending', 'wpsyslog') ?></label><br />
		</p>
		<p>
			<label for="wpsyslog_filter_limit"><strong><?php echo __('Max. Results:', 'wpsyslog') ?></strong></label><br />
			<input type="text" name="wpsyslog_filter_limit" id="wpsyslog_filter_limit" size="10" value="<?php echo $wpsyslogRequest['limit'] ?>" />
		</p>
	</div>
	<div id="wpsyslog_filter_bottom">
		<p><input type="checkbox" name="wpsyslog_show_query" id="wpsyslog_show_query"<?php echo ('on' == $_POST['wpsyslog_show_query'] ? ' checked="checked"' : '')?> />&nbsp;<label for="wpsyslog_show_query"><?php echo __('Show SQL query', 'wpsyslog') ?></label></p>
		<p><input type="hidden" name="wpsyslog_filter_do" value="true" /><input type="submit" value="<?php echo __('Filter WPsyslog data &raquo;', 'wpsyslog') ?>" /></p>
		<p><?php echo $_POST['wpsyslog_show_query'] ?></p>
	</div>
</form>

<div id="wpsyslog_data">
	<table>
		<thead>
			<tr>
				<th scope="col" class="col_id"><?php echo __('ID', 'wpsyslog') ?></th>
				<th scope="col" class="col_time"><?php echo __('Time', 'wpsyslog') ?></th>
				<th scope="col" class="col_module"><?php echo __('Module', 'wpsyslog') ?></th>
				<th scope="col" class="col_severity"><?php echo __('Severity', 'wpsyslog') ?></th>
				<th scope="col" class="col_user"><?php echo __('User', 'wpsyslog') ?></th>
				<th scope="col" class="col_message"><?php echo __('Message', 'wpsyslog') ?></th>
			</tr>
		<thead>
	<?php
	if ( is_array($wpsyslogData) && !empty($wpsyslogData) ) {
		foreach ($wpsyslogData as $entry) {

		$wpsyslogSeverity = array(
			__('Debug', 'wpsyslog'),
			__('Notice', 'wpsyslog'),
			__('Important', 'wpsyslog'),
			__('Warning', 'wpsyslog'),
			__('Error', 'wpsyslog'),
			__('Panic', 'wpsyslog')
		);
		
		$wpsyslogSeverityCss = array(
			'sev_debug',
			'sev_notice',
			'sev_important',
			'sev_warning',
			'sev_error',
			'sev_panic'
		);

		$wpsyslogTime = date( $wpsyslog_options['timeformat'], ( strtotime($entry->time) ) );

		if ( is_numeric($entry->user) ) {
			$wpsyslogUser = get_userdata($entry->user);
			$wpsyslogUser = '<a href="'.get_bloginfo('siteurl').'/wp-admin/user-edit.php?user_id='.$wpsyslogUser->ID.'" title="'.__('View user&#039;s profile', 'wpsyslog').'">'.$wpsyslogUser->display_name.'</a>';
		} else {
			$wpsyslogUser = preg_replace('|[^0-9\.]|', '', $entry->user);
		}
		
	?>
	<tr class="<?php echo $wpsyslogSeverityCss[$entry->severity] ?>">
		<td><?php echo $entry->id ?></td>
		<td><?php echo $wpsyslogTime ?></td>
		<td><?php echo $entry->module ?></td>
		<td><?php echo $wpsyslogSeverity[$entry->severity] ?></td>
		<td><?php echo $wpsyslogUser ?></td>
		<td><?php echo $entry->message ?></td>
	</tr>

	<?php
		}
	} else
		echo '<tr><td colspan="6">'.__('No results.', 'wpsyslog').'</td></tr>';
	?>
	</table>
</div>
<?php

}
?>
</div>