<div class="wrap">
<?php
/*
	WPsyslog -- Global logging facility for WordPress
	Copyright (C) 2007 Alex Guensche <http://www.zirona.com>

	This program is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation in the Version 2.
	
	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.
*/


if ( !current_user_can('level_10') && !current_user_can('manage_wpsyslog') )
	echo '<p>'.__('Sorry, this is not for you.', 'wpsyslog').'</p>';
else {

global $wpdb;

echo '<h2>'.__('Configuration for WPsyslog', 'wpsyslog').'</h2>';
echo '<form action="'.$_SERVER['REQUEST_URI'].'" method="post" id="wpsyslog_options">';

if ( 'true' === $_POST['wpsyslog_update_options'] ) {

	$wpsyslog_newoptions = array();
	$wpsyslog_newoptions['activate'] = ('on' == $_POST['wpsyslog_activate']) ? 'true' : 'false';
	$wpsyslog_newoptions['coreevents'] = ('on' == $_POST['wpsyslog_coreevents']) ? 'true' : 'false';
	$wpsyslog_newoptions['adminstealth'] = ( 'on' == $_POST['wpsyslog_adminstealth'] && current_user_can('level_10') ) ? 'true' : 'false';

	$wpsyslog_newoptions['onsubpages'] = ('on' == $_POST['wpsyslog_onsubpages']) ? 'true' : 'false';
	$wpsyslog_newoptions['timeformat'] = $wpdb->escape($_POST['wpsyslog_timeformat']);
	$wpsyslog_newoptions['tableheight'] = $wpdb->escape($_POST['wpsyslog_tableheight']);
	
	$wpsyslog_newtriggers = array();
	$wpsyslog_newtriggers['add_attachment'] = ('on' == $_POST['wpsyslog_trigger_add_attachment']) ? 'true' : 'false';
	$wpsyslog_newtriggers['delete_attachment'] = ('on' == $_POST['wpsyslog_trigger_delete_attachment']) ? 'true' : 'false';
	$wpsyslog_newtriggers['edit_attachment'] = ('on' == $_POST['wpsyslog_trigger_edit_attachment']) ? 'true' : 'false';
	$wpsyslog_newtriggers['create_category'] = ('on' == $_POST['wpsyslog_trigger_create_category']) ? 'true' : 'false';
	$wpsyslog_newtriggers['delete_category'] = ('on' == $_POST['wpsyslog_trigger_delete_category']) ? 'true' : 'false';
	$wpsyslog_newtriggers['edit_category'] = ('on' == $_POST['wpsyslog_trigger_edit_category']) ? 'true' : 'false';
	$wpsyslog_newtriggers['delete_post'] = ('on' == $_POST['wpsyslog_trigger_delete_post']) ? 'true' : 'false';
	$wpsyslog_newtriggers['save_post'] = ('on' == $_POST['wpsyslog_trigger_save_post']) ? 'true' : 'false';
	$wpsyslog_newtriggers['private_to_published'] = ('on' == $_POST['wpsyslog_trigger_private_to_published']) ? 'true' : 'false';
	$wpsyslog_newtriggers['publish_page'] = ('on' == $_POST['wpsyslog_trigger_publish_page']) ? 'true' : 'false';
	$wpsyslog_newtriggers['publish_phone'] = ('on' == $_POST['wpsyslog_trigger_publish_phone']) ? 'true' : 'false';
	$wpsyslog_newtriggers['publish_post'] = ('on' == $_POST['wpsyslog_trigger_publish_post']) ? 'true' : 'false';
	$wpsyslog_newtriggers['xmlrpc_publish_post'] = ('on' == $_POST['wpsyslog_trigger_xmlrpc_publish_post']) ? 'true' : 'false';
	$wpsyslog_newtriggers['comment_id_not_found'] = ('on' == $_POST['wpsyslog_trigger_comment_id_not_found']) ? 'true' : 'false';
	$wpsyslog_newtriggers['comment_flood_trigger'] = ('on' == $_POST['wpsyslog_trigger_comment_flood_trigger']) ? 'true' : 'false';
	$wpsyslog_newtriggers['comment_post'] = ('on' == $_POST['wpsyslog_trigger_comment_post']) ? 'true' : 'false';
	$wpsyslog_newtriggers['edit_comment'] = ('on' == $_POST['wpsyslog_trigger_edit_comment']) ? 'true' : 'false';
	$wpsyslog_newtriggers['delete_comment'] = ('on' == $_POST['wpsyslog_trigger_delete_comment']) ? 'true' : 'false';
	$wpsyslog_newtriggers['pingback_post'] = ('on' == $_POST['wpsyslog_trigger_pingback_post']) ? 'true' : 'false';
	$wpsyslog_newtriggers['trackback_post'] = ('on' == $_POST['wpsyslog_trigger_trackback_post']) ? 'true' : 'false';
	$wpsyslog_newtriggers['wp_set_comment_status'] = ('on' == $_POST['wpsyslog_trigger_wp_set_comment_status']) ? 'true' : 'false';
	$wpsyslog_newtriggers['add_link'] = ('on' == $_POST['wpsyslog_trigger_add_link']) ? 'true' : 'false';
	$wpsyslog_newtriggers['delete_link'] = ('on' == $_POST['wpsyslog_trigger_delete_link']) ? 'true' : 'false';
	$wpsyslog_newtriggers['edit_link'] = ('on' == $_POST['wpsyslog_trigger_edit_link']) ? 'true' : 'false';
	$wpsyslog_newtriggers['do_robots'] = ('on' == $_POST['wpsyslog_trigger_do_robots']) ? 'true' : 'false';
	$wpsyslog_newtriggers['switch_theme'] = ('on' == $_POST['wpsyslog_trigger_switch_theme']) ? 'true' : 'false';
	$wpsyslog_newtriggers['delete_user'] = ('on' == $_POST['wpsyslog_trigger_delete_user']) ? 'true' : 'false';
	$wpsyslog_newtriggers['retrieve_password'] = ('on' == $_POST['wpsyslog_trigger_retrieve_password']) ? 'true' : 'false';
	$wpsyslog_newtriggers['register_post'] = ('on' == $_POST['wpsyslog_trigger_register_post']) ? 'true' : 'false';
	$wpsyslog_newtriggers['user_register'] = ('on' == $_POST['wpsyslog_trigger_user_register']) ? 'true' : 'false';
	$wpsyslog_newtriggers['personal_options_update'] = ('on' == $_POST['wpsyslog_trigger_personal_options_update']) ? 'true' : 'false';
	$wpsyslog_newtriggers['profile_update'] = ('on' == $_POST['wpsyslog_trigger_profile_update']) ? 'true' : 'false';
	$wpsyslog_newtriggers['wp_login'] = ('on' == $_POST['wpsyslog_trigger_wp_login']) ? 'true' : 'false';
	$wpsyslog_newtriggers['wp_login_failed'] = ('on' == $_POST['wpsyslog_trigger_wp_login_failed']) ? 'true' : 'false';
	$wpsyslog_newtriggers['wp_logout'] = ('on' == $_POST['wpsyslog_trigger_wp_logout']) ? 'true' : 'false';
	$wpsyslog_newtriggers['generate_rewrite_rules'] = ('on' == $_POST['wpsyslog_trigger_generate_rewrite_rules']) ? 'true' : 'false';

	/* events without own API hooks */
	$wpsyslog_newtriggers['plugins'] = ('on' == $_POST['wpsyslog_trigger_plugins']) ? 'true' : 'false';

	$wpsyslog_options = get_option('wpsyslog_options');
	$wpsyslog_trigger = get_option('wpsyslog_dotrigger');

	if ('true' == $wpsyslog_options['activate'] && 'false' == $wpsyslog_newoptions['activate'])
		wpsyslog('wpsyslog', __('WPsyslog has been deactivated globally.', 'wpsyslog'), 3);
	elseif ('false' == $wpsyslog_options['activate'] && 'true' == $wpsyslog_newoptions['activate'])
		wpsyslog('wpsyslog', __('WPsyslog has been activated globally.', 'wpsyslog'), 2);

	if ('true' == $wpsyslog_options['coreevents'] && 'false' == $wpsyslog_newoptions['coreevents'])
		wpsyslog('wpsyslog', __('Core events logging has been deactivated.', 'wpsyslog'), 3);
	elseif ('false' == $wpsyslog_options['coreevents'] && 'true' == $wpsyslog_newoptions['coreevents'])
		wpsyslog('wpsyslog', __('Core events logging has been activated.', 'wpsyslog'), 2);

	$wpsyslog_trigger_diff1 = array_diff($wpsyslog_trigger, $wpsyslog_newtriggers);
	$wpsyslog_trigger_diff2 = array_diff($wpsyslog_newtriggers, $wpsyslog_trigger);
	if ( !empty($wpsyslog_trigger_diff1) || !empty($wpsyslog_trigger_diff2) )
		wpsyslog('wpsyslog', __('The set of core events to log has been modified.', 'wpsyslog'), 1);

	update_option('wpsyslog_options', $wpsyslog_newoptions);
	update_option('wpsyslog_dotrigger', $wpsyslog_newtriggers);

	wpsyslog('wpsyslog', __('WPsyslog configuration has been changed.', 'wpsyslog'), 2);
}

$wpsyslog_options = get_option('wpsyslog_options');
$wpsyslog_trigger = get_option('wpsyslog_dotrigger');


echo '<fieldset>';
echo '<h3>'.__('Main configuration', 'wpsyslog').'</h3>';
echo '<p><input type="checkbox" name="wpsyslog_activate" id="wpsyslog_activate"'.($wpsyslog_options['activate'] != 'false' ? 'checked="checked"' : '').' />&nbsp;<label for="wpsyslog_activate"><strong>'.__('Activate WPsyslog', 'wpsyslog').'</strong></label><br />'.__('This is the main switch to activate or deactivate all system logging (WPsyslog itself cannot be deactivated here for security reasons).', 'wpsyslog').'</p>';

echo '<p><input type="checkbox" name="wpsyslog_coreevents" id="wpsyslog_coreevents"'.($wpsyslog_options['coreevents'] != 'false' ? 'checked="checked"' : '').' />&nbsp;<label for="wpsyslog_coreevents"><strong>'.__('Log core events', 'wpsyslog').'</strong></label><br />'.__('Activate/deactivate logging events of the WordPress core. This is helpful to keep track of the happenings in your blog, especially on a multiuser blog.', 'wpsyslog').'</p>';

echo '<h3>'.__('Display options', 'wpsyslog').'</h3>';

if ( empty($wp_version) || version_compare($wp_version, '2.2', '>=') )
	echo '<p><input type="checkbox" name="wpsyslog_onsubpages" id="wpsyslog_onsubpages"'.($wpsyslog_options['onsubpages'] == 'true' ? 'checked="checked"' : '').' />&nbsp;<label for="wpsyslog_onsubpages"><strong>'.__('Display on subpages', 'wpsyslog').'</strong></label><br />'.__('Instead of having a top level menu item with two tabs, WPsyslog will be intergated into the Manage and Options top level menus. Only available in WordPress 2.2 and higher.', 'wpsyslog').'</p>';

echo '<p class="blocklabel"><label for="wpsyslog_timeformat">'.__('<strong>Time format</strong> in log table (in <code><a href="http://php.net/date">date()</a></code> format):', 'wpsyslog').'</label> <input type="text" name="wpsyslog_timeformat" id="wpsyslog_timeformat" value="'.$wpsyslog_options['timeformat'].'" size="12"></p>';

echo '<p class="blocklabel"><label for="wpsyslog_tableheight">'.__('<strong>Height of the log data table</strong>, in pixels:', 'wpsyslog').'</label> <input type="text" name="wpsyslog_tableheight" id="wpsyslog_tableheight" value="'.$wpsyslog_options['tableheight'].'" size="5"></p>';

/*
	More options (todo)
	- Do colorize output? Colors?
	- Show inline HTML in Log messages?
*/

echo '</fieldset>';


echo '<fieldset>';
echo '<h3>'.__('Core events to log (if core event logging is activated)', 'wpsyslog').'</h3>';
echo '<p><strong>'.__('Note: Please respect your user&#039;s privacy and log only data that you really need.', 'wpsyslog').'</strong><p>';
echo '<p><input type="checkbox" name="wpsyslog_trigger_add_attachment" id="wpsyslog_trigger_add_attachment"'.($wpsyslog_trigger['add_attachment'] != 'false' ? 'checked="checked"' : '').' />&nbsp;<label for="wpsyslog_trigger_add_attachment"><code>add_attachment</code> *</label><br />';
echo '<input type="checkbox" name="wpsyslog_trigger_delete_attachment" id="wpsyslog_trigger_delete_attachment"'.($wpsyslog_trigger['delete_attachment'] != 'false' ? 'checked="checked"' : '').' />&nbsp;<label for="wpsyslog_trigger_delete_attachment"><code>delete_attachment</code> *</label><br />';
echo '<input type="checkbox" name="wpsyslog_trigger_edit_attachment" id="wpsyslog_trigger_edit_attachment"'.($wpsyslog_trigger['edit_attachment'] != 'false' ? 'checked="checked"' : '').' />&nbsp;<label for="wpsyslog_trigger_edit_attachment"><code>edit_attachment</code> *</label><br />';
echo '<input type="checkbox" name="wpsyslog_trigger_create_category" id="wpsyslog_trigger_create_category"'.($wpsyslog_trigger['create_category'] != 'false' ? 'checked="checked"' : '').' />&nbsp;<label for="wpsyslog_trigger_create_category"><code>create_category</code> *</label><br />';
echo '<input type="checkbox" name="wpsyslog_trigger_delete_category" id="wpsyslog_trigger_delete_category"'.($wpsyslog_trigger['delete_category'] != 'false' ? 'checked="checked"' : '').' />&nbsp;<label for="wpsyslog_trigger_delete_category"><code>delete_category</code> *</label><br />';
echo '<input type="checkbox" name="wpsyslog_trigger_edit_category" id="wpsyslog_trigger_edit_category"'.($wpsyslog_trigger['edit_category'] != 'false' ? 'checked="checked"' : '').' />&nbsp;<label for="wpsyslog_trigger_edit_category"><code>edit_category</code> *</label><br />';
echo '<input type="checkbox" name="wpsyslog_trigger_delete_post" id="wpsyslog_trigger_delete_post"'.($wpsyslog_trigger['delete_post'] != 'false' ? 'checked="checked"' : '').' />&nbsp;<label for="wpsyslog_trigger_delete_post"><code>delete_post</code> *</label><br />';
echo '<input type="checkbox" name="wpsyslog_trigger_save_post" id="wpsyslog_trigger_save_post"'.($wpsyslog_trigger['save_post'] != 'false' ? 'checked="checked"' : '').' />&nbsp;<label for="wpsyslog_trigger_save_post"><code>save_post</code> *</label><br />';
echo '<input type="checkbox" name="wpsyslog_trigger_private_to_published" id="wpsyslog_trigger_private_to_published"'.($wpsyslog_trigger['private_to_published'] != 'false' ? 'checked="checked"' : '').' />&nbsp;<label for="wpsyslog_trigger_private_to_published"><code>private_to_published</code> *</label><br />';
echo '<input type="checkbox" name="wpsyslog_trigger_publish_page" id="wpsyslog_trigger_publish_page"'.($wpsyslog_trigger['publish_page'] != 'false' ? 'checked="checked"' : '').' />&nbsp;<label for="wpsyslog_trigger_publish_page"><code>publish_page</code> *</label><br />';
echo '<input type="checkbox" name="wpsyslog_trigger_publish_phone" id="wpsyslog_trigger_publish_phone"'.($wpsyslog_trigger['publish_phone'] != 'false' ? 'checked="checked"' : '').' />&nbsp;<label for="wpsyslog_trigger_publish_phone"><code>publish_phone</code> *</label><br />';
echo '<input type="checkbox" name="wpsyslog_trigger_publish_post" id="wpsyslog_trigger_publish_post"'.($wpsyslog_trigger['publish_post'] != 'false' ? 'checked="checked"' : '').' />&nbsp;<label for="wpsyslog_trigger_publish_post"><code>publish_post</code> *</label><br />';
echo '<input type="checkbox" name="wpsyslog_trigger_xmlrpc_publish_post" id="wpsyslog_trigger_xmlrpc_publish_post"'.($wpsyslog_trigger['xmlrpc_publish_post'] != 'false' ? 'checked="checked"' : '').' />&nbsp;<label for="wpsyslog_trigger_xmlrpc_publish_post"><code>xmlrpc_publish_post</code> *</label><br />';
echo '<input type="checkbox" name="wpsyslog_trigger_comment_id_not_found" id="wpsyslog_trigger_comment_id_not_found"'.($wpsyslog_trigger['comment_id_not_found'] != 'false' ? 'checked="checked"' : '').' />&nbsp;<label for="wpsyslog_trigger_comment_id_not_found"><code>comment_id_not_found</code> *</label><br />';
echo '<input type="checkbox" name="wpsyslog_trigger_comment_flood_trigger" id="wpsyslog_trigger_comment_flood_trigger"'.($wpsyslog_trigger['comment_flood_trigger'] != 'false' ? 'checked="checked"' : '').' />&nbsp;<label for="wpsyslog_trigger_comment_flood_trigger"><code>comment_flood_trigger</code> *</label><br />';
echo '<input type="checkbox" name="wpsyslog_trigger_comment_post" id="wpsyslog_trigger_comment_post"'.($wpsyslog_trigger['comment_post'] != 'false' ? 'checked="checked"' : '').' />&nbsp;<label for="wpsyslog_trigger_comment_post"><code>comment_post</code> *</label><br />';
echo '<input type="checkbox" name="wpsyslog_trigger_edit_comment" id="wpsyslog_trigger_edit_comment"'.($wpsyslog_trigger['edit_comment'] != 'false' ? 'checked="checked"' : '').' />&nbsp;<label for="wpsyslog_trigger_edit_comment"><code>edit_comment</code> *</label><br />';
echo '<input type="checkbox" name="wpsyslog_trigger_delete_comment" id="wpsyslog_trigger_delete_comment"'.($wpsyslog_trigger['delete_comment'] != 'false' ? 'checked="checked"' : '').' />&nbsp;<label for="wpsyslog_trigger_delete_comment"><code>delete_comment</code> *</label><br />';
echo '<input type="checkbox" name="wpsyslog_trigger_pingback_post" id="wpsyslog_trigger_pingback_post"'.($wpsyslog_trigger['pingback_post'] != 'false' ? 'checked="checked"' : '').' />&nbsp;<label for="wpsyslog_trigger_pingback_post"><code>pingback_post</code> *</label><br />';
echo '<input type="checkbox" name="wpsyslog_trigger_trackback_post" id="wpsyslog_trigger_trackback_post"'.($wpsyslog_trigger['trackback_post'] != 'false' ? 'checked="checked"' : '').' />&nbsp;<label for="wpsyslog_trigger_trackback_post"><code>trackback_post</code> *</label><br />';
echo '<input type="checkbox" name="wpsyslog_trigger_wp_set_comment_status" id="wpsyslog_trigger_wp_set_comment_status"'.($wpsyslog_trigger['wp_set_comment_status'] != 'false' ? 'checked="checked"' : '').' />&nbsp;<label for="wpsyslog_trigger_wp_set_comment_status"><code>wp_set_comment_status</code> *</label><br />';
echo '<input type="checkbox" name="wpsyslog_trigger_add_link" id="wpsyslog_trigger_add_link"'.($wpsyslog_trigger['add_link'] != 'false' ? 'checked="checked"' : '').' />&nbsp;<label for="wpsyslog_trigger_add_link"><code>add_link</code> *</label><br />';
echo '<input type="checkbox" name="wpsyslog_trigger_delete_link" id="wpsyslog_trigger_delete_link"'.($wpsyslog_trigger['delete_link'] != 'false' ? 'checked="checked"' : '').' />&nbsp;<label for="wpsyslog_trigger_delete_link"><code>delete_link</code> *</label><br />';
echo '<input type="checkbox" name="wpsyslog_trigger_edit_link" id="wpsyslog_trigger_edit_link"'.($wpsyslog_trigger['edit_link'] != 'false' ? 'checked="checked"' : '').' />&nbsp;<label for="wpsyslog_trigger_edit_link"><code>edit_link</code> *</label><br />';
echo '<input type="checkbox" name="wpsyslog_trigger_do_robots" id="wpsyslog_trigger_do_robots"'.($wpsyslog_trigger['do_robots'] != 'false' ? 'checked="checked"' : '').' />&nbsp;<label for="wpsyslog_trigger_do_robots"><code>do_robots</code> *</label><br />';
echo '<input type="checkbox" name="wpsyslog_trigger_switch_theme" id="wpsyslog_trigger_switch_theme"'.($wpsyslog_trigger['switch_theme'] != 'false' ? 'checked="checked"' : '').' />&nbsp;<label for="wpsyslog_trigger_switch_theme"><code>switch_theme</code> *</label><br />';
echo '<input type="checkbox" name="wpsyslog_trigger_delete_user" id="wpsyslog_trigger_delete_user"'.($wpsyslog_trigger['delete_user'] != 'false' ? 'checked="checked"' : '').' />&nbsp;<label for="wpsyslog_trigger_delete_user"><code>delete_user</code> *</label><br />';
echo '<input type="checkbox" name="wpsyslog_trigger_retrieve_password" id="wpsyslog_trigger_retrieve_password"'.($wpsyslog_trigger['retrieve_password'] != 'false' ? 'checked="checked"' : '').' />&nbsp;<label for="wpsyslog_trigger_retrieve_password"><code>retrieve_password</code> *</label><br />';
echo '<input type="checkbox" name="wpsyslog_trigger_register_post" id="wpsyslog_trigger_register_post"'.($wpsyslog_trigger['register_post'] != 'false' ? 'checked="checked"' : '').' />&nbsp;<label for="wpsyslog_trigger_register_post"><code>register_post</code> *</label><br />';
echo '<input type="checkbox" name="wpsyslog_trigger_user_register" id="wpsyslog_trigger_user_register"'.($wpsyslog_trigger['user_register'] != 'false' ? 'checked="checked"' : '').' />&nbsp;<label for="wpsyslog_trigger_user_register"><code>user_register</code> *</label><br />';
echo '<input type="checkbox" name="wpsyslog_trigger_personal_options_update" id="wpsyslog_trigger_personal_options_update"'.($wpsyslog_trigger['personal_options_update'] != 'false' ? 'checked="checked"' : '').' />&nbsp;<label for="wpsyslog_trigger_personal_options_update"><code>personal_options_update</code> *</label><br />';
echo '<input type="checkbox" name="wpsyslog_trigger_profile_update" id="wpsyslog_trigger_profile_update"'.($wpsyslog_trigger['profile_update'] != 'false' ? 'checked="checked"' : '').' />&nbsp;<label for="wpsyslog_trigger_profile_update"><code>profile_update</code> *</label><br />';
echo '<input type="checkbox" name="wpsyslog_trigger_wp_login" id="wpsyslog_trigger_wp_login"'.($wpsyslog_trigger['wp_login'] != 'false' ? 'checked="checked"' : '').' />&nbsp;<label for="wpsyslog_trigger_wp_login"><code>wp_login</code> *</label><br />';
echo '<input type="checkbox" name="wpsyslog_trigger_wp_login_failed" id="wpsyslog_trigger_wp_login_failed"'.($wpsyslog_trigger['wp_login_failed'] != 'false' ? 'checked="checked"' : '').' />&nbsp;<label for="wpsyslog_trigger_wp_login_failed"><code>wp_login_failed</code> *</label><br />';
echo '<input type="checkbox" name="wpsyslog_trigger_wp_logout" id="wpsyslog_trigger_wp_logout"'.($wpsyslog_trigger['wp_logout'] != 'false' ? 'checked="checked"' : '').' />&nbsp;<label for="wpsyslog_trigger_wp_logout"><code>wp_logout</code> *</label><br />';
echo '<input type="checkbox" name="wpsyslog_trigger_generate_rewrite_rules" id="wpsyslog_trigger_generate_rewrite_rules"'.($wpsyslog_trigger['generate_rewrite_rules'] != 'false' ? 'checked="checked"' : '').' />&nbsp;<label for="wpsyslog_trigger_generate_rewrite_rules"><code>generate_rewrite_rules</code> *</label></p>';

echo '<p><input type="checkbox" name="wpsyslog_trigger_plugins" id="wpsyslog_trigger_plugins"'.($wpsyslog_trigger['plugins'] != 'false' ? 'checked="checked"' : '').' />&nbsp;<label for="wpsyslog_trigger_plugins">'.__('Plugin activation/deactivation', 'wpsyslog').' **</label></p>';
echo '</fieldset>';

echo '<p class="small"><code>*&nbsp;&nbsp;</code>'.sprintf(__('See the <a href="%s">API Action Reference</a> for explainations of the hooks.', 'wpsyslog'), 'http://codex.wordpress.org/Plugin_API/Action_Reference').'</p>';
echo '<p class="small"><code>**&nbsp;</code>'.__('Other events, e.g. determinded via <code>$_GET</code> and <code>$_POST</code> parameters.', 'wpsyslog').'</p>';

echo '<p><input type="hidden" name="wpsyslog_update_options" value="true" /><input type="submit" value="'.__('Save WPsyslog options &raquo;', 'wpsyslog').'" /></p>';
echo '</form>';
}
?>
</div>
